#ifndef __THE_REAL_SCT_USER_H__
#define __THE_REAL_SCT_USER_H__

#include "board.h"

/** Macro to define register bits and mask in CMSIS style */
#define SCT_DefineRegBit(name,pos,width) \
    enum { \
        name##_Pos = pos, \
        name##_Msk = (int)(((1ul << width) - 1) << pos), \
    }


/* Declarations of SCT register fields */
SCT_DefineRegBit(SCT_CTRL_U_DOWN_L,					0,  1);
SCT_DefineRegBit(SCT_CTRL_U_STOP_L,					1,  1);
SCT_DefineRegBit(SCT_CTRL_U_HALT_L,					2,  1);
SCT_DefineRegBit(SCT_CTRL_U_CLRCTR_L,				3,  1);
SCT_DefineRegBit(SCT_CTRL_U_BIDIR_L,				4,  1);
SCT_DefineRegBit(SCT_CTRL_U_PRE_L,					5,  8);
SCT_DefineRegBit(SCT_CTRL_U_DOWN_H,					16, 1);
SCT_DefineRegBit(SCT_CTRL_U_STOP_H,					17, 1);
SCT_DefineRegBit(SCT_CTRL_U_HALT_H,					18, 1);
SCT_DefineRegBit(SCT_CTRL_U_CLRCTR_H,				19, 1);
SCT_DefineRegBit(SCT_CTRL_U_BIDIR_H,				20, 1);
SCT_DefineRegBit(SCT_CTRL_U_PRE_H,					21, 8);

SCT_DefineRegBit(SCT_CTRL_L_DOWN_L,					0,  1);
SCT_DefineRegBit(SCT_CTRL_L_STOP_L,					1,  1);
SCT_DefineRegBit(SCT_CTRL_L_HALT_L,					2,  1);
SCT_DefineRegBit(SCT_CTRL_L_CLRCTR_L,				3,  1);
SCT_DefineRegBit(SCT_CTRL_L_BIDIR_L,				4,  1);
SCT_DefineRegBit(SCT_CTRL_L_PRE_L,					5,  8);

SCT_DefineRegBit(SCT_CTRL_H_DOWN_H,					0,  1);
SCT_DefineRegBit(SCT_CTRL_H_STOP_H,					1,  1);
SCT_DefineRegBit(SCT_CTRL_H_HALT_H,					2,  1);
SCT_DefineRegBit(SCT_CTRL_H_CLRCTR_H,				3,  1);
SCT_DefineRegBit(SCT_CTRL_H_BIDIR_H,				4,  1);
SCT_DefineRegBit(SCT_CTRL_H_PRE_H,					5,  8);


/* Define expected signal characteristics */
#define PULSE_FREQUENCY			36000		/* Burst pulse frequency in Hz */
#define PULSE_TICKS				111			/* Ticks per 36 kHz pulse */
#define PULSE_DUTY_CYCLE		25			/* Duty cycle in % */

/* Derived constants */
#define SCT_PRESCALER			(SystemCoreClock / (PULSE_FREQUENCY * 100u))
#define SCT_MATCH_DUTY_CYCLE	(PULSE_TICKS - 1 - (PULSE_DUTY_CYCLE * PULSE_TICKS) / 100u)
#define SCT_MATCH_PULSE_LENGTH	(PULSE_TICKS - 1)

#define RC5_BIT_DIVIDER			(SCT_PRESCALER * PULSE_TICKS * 32)

#endif
